/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.concentrationrank;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Optional;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.network.RankSyncMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public interface IConcentrationRank {
    public long getRawRankPoint();

    public void setRawRankPoint(long var1);

    public long getLastUpdate();

    public void setLastUpdte(long var1);

    public long getLastRankRise();

    public void setLastRankRise(long var1);

    public long getUnitCapacity();

    default public long getMaxCapacity() {
        return (long)(ConcentrationRanks.MAX_LEVEL * (float)this.getUnitCapacity()) - 1L;
    }

    default public ConcentrationRanks getRank(long time) {
        return ConcentrationRanks.getRankFromLevel(this.getRankLevel(time));
    }

    default public long reductionLimitter(long reduction) {
        long limit = this.getRawRankPoint() % this.getUnitCapacity();
        return Math.min(reduction, limit);
    }

    default public float getRankLevel(long currentTime) {
        return (float)this.getRankPoint(currentTime) / (float)this.getUnitCapacity();
    }

    default public float getRankProgress(long currentTime) {
        float level = this.getRankLevel(currentTime);
        Range<Float> range = this.getRank((long)currentTime).pointRange;
        double bottom = range.hasLowerBound() ? (double)((Float)range.lowerEndpoint()).floatValue() : 0.0;
        double top = range.hasUpperBound() ? (double)((Float)range.upperEndpoint()).floatValue() : Math.floor(bottom + 1.0);
        double len = top - bottom;
        return (float)(((double)level - bottom) / len);
    }

    default public long getRankPoint(long time) {
        long reduction = time - this.getLastUpdate();
        return this.getRawRankPoint() - this.reductionLimitter(reduction);
    }

    default public void addRankPoint(LivingEntity user, long point) {
        long time = user.m_9236_().m_46467_();
        ConcentrationRanks oldRank = this.getRank(time);
        this.setRawRankPoint(Math.min(Math.max(0L, point + this.getRankPoint(time)), this.getMaxCapacity()));
        this.setLastUpdte(time);
        if (oldRank.level < this.getRank((long)time).level) {
            this.setLastRankRise(time);
        }
        if (user instanceof ServerPlayer && !user.m_9236_().m_5776_()) {
            if (((ServerPlayer)user).f_8906_ == null) {
                return;
            }
            RankSyncMessage msg = new RankSyncMessage();
            msg.rawPoint = this.getRawRankPoint();
            NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)user), (Object)msg);
        }
    }

    default public void addRankPoint(DamageSource src) {
        if (!(src.m_7639_() instanceof LivingEntity)) {
            return;
        }
        LivingEntity user = (LivingEntity)src.m_7639_();
        ItemStack stack = user.m_21205_();
        Optional combo = stack.getCapability(ItemSlashBlade.BLADESTATE).map(s -> s.resolvCurrentComboState(user));
        float modifier = combo.map(c -> Float.valueOf(this.getRankPointModifier((ResourceLocation)c))).orElse(Float.valueOf(this.getRankPointModifier(src))).floatValue();
        this.addRankPoint(user, (long)(modifier * (float)this.getUnitCapacity()));
    }

    public float getRankPointModifier(DamageSource var1);

    public float getRankPointModifier(ResourceLocation var1);

    public static enum ConcentrationRanks {
        NONE(0, (Range<Float>)Range.lessThan((Comparable)Float.valueOf(1.0f))),
        D(1, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(2.0f))),
        C(2, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(2.0f), (Comparable)Float.valueOf(3.0f))),
        B(3, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(3.0f), (Comparable)Float.valueOf(4.0f))),
        A(4, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(4.0f), (Comparable)Float.valueOf(5.0f))),
        S(5, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(5.0f), (Comparable)Float.valueOf(5.25f))),
        SS(6, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(5.25f), (Comparable)Float.valueOf(5.5f))),
        SSS(7, (Range<Float>)Range.atLeast((Comparable)Float.valueOf(5.5f)));

        public static float MAX_LEVEL;
        final Range<Float> pointRange;
        public final int level;
        private static RangeMap<Float, ConcentrationRanks> concentrationRanksMap;

        private ConcentrationRanks(int level, Range<Float> pointRange) {
            this.pointRange = pointRange;
            this.level = level;
        }

        public static ConcentrationRanks getRankFromLevel(float point) {
            return (ConcentrationRanks)((Object)concentrationRanksMap.get((Comparable)Float.valueOf(point)));
        }

        static {
            MAX_LEVEL = 6.0f;
            concentrationRanksMap = ImmutableRangeMap.builder().put(ConcentrationRanks.NONE.pointRange, (Object)NONE).put(ConcentrationRanks.D.pointRange, (Object)D).put(ConcentrationRanks.C.pointRange, (Object)C).put(ConcentrationRanks.B.pointRange, (Object)B).put(ConcentrationRanks.A.pointRange, (Object)A).put(ConcentrationRanks.S.pointRange, (Object)S).put(ConcentrationRanks.SS.pointRange, (Object)SS).put(ConcentrationRanks.SSS.pointRange, (Object)SSS).build();
        }
    }
}

